"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartnerEntity = void 0;
const wallet_entity_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.entity");
const typeorm_1 = require("typeorm");
const base_entity_1 = require("./base.entity");
const base_enum_1 = require("../enums/base.enum");
const partner_enum_1 = require("../enums/partner.enum");
const provider_enum_1 = require("../enums/provider.enum");
const user_detail_entity_1 = require("../modules/authentication/entities/user-detail.entity");
const sms_transaction_entity_1 = require("./sms/sms-transaction.entity");
const sms_entity_1 = require("./sms/sms.entity");
const short_code_entity_1 = require("./short-code/short-code.entity");
const product_entity_1 = require("./product/product.entity");
const kyc_entity_1 = require("./kyc/kyc.entity");
const product_group_entity_1 = require("./product/product-group.entity");
const webhook_entity_1 = require("./webhook.entity");
let PartnerEntity = class PartnerEntity extends base_entity_1.BaseEntity {
};
exports.PartnerEntity = PartnerEntity;
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], PartnerEntity.prototype, "phoneNumber", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], PartnerEntity.prototype, "email", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "double", nullable: true }),
    __metadata("design:type", Number)
], PartnerEntity.prototype, "priority", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true, select: false }),
    __metadata("design:type", String)
], PartnerEntity.prototype, "apiKey", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text" }),
    __metadata("design:type", String)
], PartnerEntity.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "enum", enum: partner_enum_1.EPartnerType }),
    __metadata("design:type", String)
], PartnerEntity.prototype, "type", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "enum", enum: provider_enum_1.EProvider, nullable: true, unique: true }),
    __metadata("design:type", String)
], PartnerEntity.prototype, "providerCode", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text", nullable: true }),
    __metadata("design:type", String)
], PartnerEntity.prototype, "webhookUrl", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => wallet_entity_1.WalletEntity),
    (0, typeorm_1.JoinColumn)({ referencedColumnName: "id", name: "promotionalWalletId" }),
    __metadata("design:type", Object)
], PartnerEntity.prototype, "promotionalWallet", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], PartnerEntity.prototype, "promotionalWalletId", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => wallet_entity_1.WalletEntity),
    (0, typeorm_1.JoinColumn)({ referencedColumnName: "id", name: "transactionalWalletId" }),
    __metadata("design:type", Object)
], PartnerEntity.prototype, "transactionalWallet", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], PartnerEntity.prototype, "transactionalWalletId", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => user_detail_entity_1.UserDetailEntity, (i) => i.partner),
    (0, typeorm_1.JoinColumn)(),
    __metadata("design:type", Object)
], PartnerEntity.prototype, "manager", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], PartnerEntity.prototype, "managerId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => product_entity_1.ProductEntity, (i) => i.currentPromotionalClients),
    (0, typeorm_1.JoinColumn)(),
    __metadata("design:type", Object)
], PartnerEntity.prototype, "currentPromotionalProduct", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], PartnerEntity.prototype, "currentPromotionalProductId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => product_entity_1.ProductEntity, (i) => i.currentTransactionalClients),
    (0, typeorm_1.JoinColumn)(),
    __metadata("design:type", Object)
], PartnerEntity.prototype, "currentTransactionalProduct", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], PartnerEntity.prototype, "currentTransactionalProductId", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => user_detail_entity_1.UserDetailEntity, (i) => i.owner),
    __metadata("design:type", Object)
], PartnerEntity.prototype, "users", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => sms_entity_1.SMSEntity, (i) => i.client),
    __metadata("design:type", Object)
], PartnerEntity.prototype, "messages", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => sms_transaction_entity_1.SMSTransactionEntity, (i) => i.provider),
    __metadata("design:type", Object)
], PartnerEntity.prototype, "messageTransactions", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => short_code_entity_1.ShortCodeEntity, (i) => i.owner),
    __metadata("design:type", Object)
], PartnerEntity.prototype, "shortCodes", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => kyc_entity_1.KYCEntity, (i) => i.client),
    __metadata("design:type", Object)
], PartnerEntity.prototype, "kycs", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => webhook_entity_1.WebhookEntity, (i) => i.partner),
    __metadata("design:type", Object)
], PartnerEntity.prototype, "webhooks", void 0);
__decorate([
    (0, typeorm_1.OneToOne)(() => product_group_entity_1.ProductGroupEntity, (i) => i.provider),
    __metadata("design:type", product_group_entity_1.ProductGroupEntity)
], PartnerEntity.prototype, "pricingGroup", void 0);
exports.PartnerEntity = PartnerEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.partner)
], PartnerEntity);
//# sourceMappingURL=partner.entity.js.map