import { WalletEntity } from "@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.entity";
import { Relation } from "typeorm";
import { BaseEntity } from "./base.entity";
import { EPartnerType } from "../enums/partner.enum";
import { EProvider } from "../enums/provider.enum";
import { UserDetailEntity } from "../modules/authentication/entities/user-detail.entity";
import { SMSTransactionEntity } from "./sms/sms-transaction.entity";
import { SMSEntity } from "./sms/sms.entity";
import { ShortCodeEntity } from "./short-code/short-code.entity";
import { ProductEntity } from "./product/product.entity";
import { KYCEntity } from "./kyc/kyc.entity";
import { ProductGroupEntity } from "./product/product-group.entity";
import { WebhookEntity } from "./webhook.entity";
export declare class PartnerEntity extends BaseEntity {
    phoneNumber?: string;
    email?: string;
    priority?: number;
    apiKey?: string;
    name: string;
    type: EPartnerType;
    providerCode?: EProvider;
    webhookUrl?: string;
    promotionalWallet?: Relation<WalletEntity>;
    promotionalWalletId?: string;
    transactionalWallet?: Relation<WalletEntity>;
    transactionalWalletId?: string;
    manager: Relation<UserDetailEntity>;
    managerId?: string;
    currentPromotionalProduct: Relation<ProductEntity>;
    currentPromotionalProductId?: string;
    currentTransactionalProduct: Relation<ProductEntity>;
    currentTransactionalProductId?: string;
    users: Relation<UserDetailEntity[]>;
    messages?: Relation<SMSEntity[]>;
    messageTransactions?: Relation<SMSTransactionEntity[]>;
    shortCodes?: Relation<ShortCodeEntity[]>;
    kycs?: Relation<KYCEntity[]>;
    webhooks?: Relation<WebhookEntity[]>;
    pricingGroup: ProductGroupEntity;
}
