"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.KYCAnalysisView = exports.KYCView = void 0;
const typeorm_1 = require("typeorm");
const base_enum_1 = require("../../enums/base.enum");
const partner_enum_1 = require("../../enums/partner.enum");
const kyc_enum_1 = require("../../enums/kyc.enum");
let KYCView = class KYCView {
};
exports.KYCView = KYCView;
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "userComment", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "review", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "fileId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "reviewerId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "templateId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "clientId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "creatorId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "updaterId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "updatedAt", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "code", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "title", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "description", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)({ transformer: { from: (v) => (v == 1 ? true : false), to: (v) => (v == true ? 1 : 0) } }),
    __metadata("design:type", Boolean)
], KYCView.prototype, "required", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)({ transformer: { from: (v) => (v == 1 ? true : false), to: (v) => (v == true ? 1 : 0) } }),
    __metadata("design:type", Boolean)
], KYCView.prototype, "templateActive", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "clientName", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "reviewer", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "creator", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCView.prototype, "updater", void 0);
exports.KYCView = KYCView = __decorate([
    (0, typeorm_1.ViewEntity)({
        name: base_enum_1.ETableName.kycView,
        expression: `
    SELECT
    kt.code AS code,
    kt.id AS templateId,
    kt.title AS title,
    kt.description AS description,
    kt.required AS required,
    kt.active AS templateActive,
    p.name AS clientName,
    p.id AS clientId,
    k.id AS id,
    k.userComment AS userComment,
    k.status AS status,
    k.review AS review,
    k.fileId AS fileId,
    k.creatorId AS creatorId,
    k.updaterId AS updaterId,
    k.createdAt AS createdAt,
    k.updatedAt AS updatedAt,
    k.reviewerId AS reviewerId,
    CONCAT( aReviewer.firstname, " ",aReviewer.lastname) as reviewer,
    CONCAT( aCreator.firstname, " ",aCreator.lastname) as creator,
    CONCAT( aUpdater.firstname, " ",aUpdater.lastname) as updater
FROM
    ${base_enum_1.ETableName.kycTemplate} AS kt
JOIN ${base_enum_1.ETableName.partner} AS p
LEFT JOIN ${base_enum_1.ETableName.kyc} AS k
ON
    k.templateId = kt.id AND k.clientId = p.id
LEFT JOIN ${base_enum_1.ETableName.authentication} AS aReviewer
ON
    aReviewer.id = k.reviewerId
LEFT JOIN ${base_enum_1.ETableName.authentication} AS aCreator
ON
    aCreator.id = k.creatorId
LEFT JOIN ${base_enum_1.ETableName.authentication} AS aUpdater
ON
    aUpdater.id = k.updaterId
WHERE
kt.deletedAt IS NULL AND p.type = '${partner_enum_1.EPartnerType.client}' AND p.deletedAt IS NULL;`,
    })
], KYCView);
let KYCAnalysisView = class KYCAnalysisView {
};
exports.KYCAnalysisView = KYCAnalysisView;
__decorate([
    (0, typeorm_1.ViewColumn)({ transformer: { from: (v) => (v == 1 ? true : false), to: (v) => (v == true ? 1 : 0) } }),
    __metadata("design:type", Boolean)
], KYCAnalysisView.prototype, "approved", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)({ transformer: { from: (v) => +v, to: (v) => v } }),
    __metadata("design:type", Number)
], KYCAnalysisView.prototype, "templatesCount", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCAnalysisView.prototype, "clientId", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", String)
], KYCAnalysisView.prototype, "clientName", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)({ transformer: { from: (v) => +v, to: (v) => v } }),
    __metadata("design:type", Number)
], KYCAnalysisView.prototype, "approvedCount", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)({ transformer: { from: (v) => +v, to: (v) => v } }),
    __metadata("design:type", Number)
], KYCAnalysisView.prototype, "pendingCount", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)({ transformer: { from: (v) => +v, to: (v) => v } }),
    __metadata("design:type", Number)
], KYCAnalysisView.prototype, "rejectedCount", void 0);
exports.KYCAnalysisView = KYCAnalysisView = __decorate([
    (0, typeorm_1.ViewEntity)({
        name: base_enum_1.ETableName.kycAnalysis,
        expression: `
   SELECT
    IF(
    templatesCount = approvedCount,
    1,
    0
) AS approved,
templatesCount,
clientId,
clientName,
approvedCount,
pendingCount,
rejectedCount
FROM
    (
        (
        SELECT
            COUNT(*) AS templatesCount
        FROM
            ${base_enum_1.ETableName.kycTemplate}
        WHERE
            ${base_enum_1.ETableName.kycTemplate}.active = 1 AND ${base_enum_1.ETableName.kycTemplate}.deletedAt IS NULL
    ) templatesCount,
    (
    SELECT
        ${base_enum_1.ETableName.partner}.id AS clientId,
        ${base_enum_1.ETableName.partner}.name AS clientName,
        (
        SELECT
            COUNT(*) AS approvedCount
        FROM
            ${base_enum_1.ETableName.kycView}
        WHERE
            ${base_enum_1.ETableName.kycView}.clientId = ${base_enum_1.ETableName.partner}.id AND ${base_enum_1.ETableName.kycView}.status = 'APPROVED'
    ) approvedCount,
    (
    SELECT
        COUNT(*) AS pendingCount
    FROM
        ${base_enum_1.ETableName.kycView}
    WHERE
        ${base_enum_1.ETableName.kycView}.clientId = ${base_enum_1.ETableName.partner}.id AND ${base_enum_1.ETableName.kycView}.status = 'PENDING'
) pendingCount,
(
    SELECT
        COUNT(*) AS rejectedCount
    FROM
        ${base_enum_1.ETableName.kycView}
    WHERE
        ${base_enum_1.ETableName.kycView}.clientId = ${base_enum_1.ETableName.partner}.id AND ${base_enum_1.ETableName.kycView}.status = 'REJECTED'
) rejectedCount
FROM
    ${base_enum_1.ETableName.partner}
WHERE
    ${base_enum_1.ETableName.partner}.type = 'CLIENT'
) CLIENT
    );`,
    })
], KYCAnalysisView);
//# sourceMappingURL=kyc.view.entity.js.map