"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.entities = void 0;
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const authentication_module_1 = require("../modules/authentication/authentication.module");
const token_entity_1 = require("./token.entity");
const partner_entity_1 = require("./partner.entity");
const sms_transaction_entity_1 = require("./sms/sms-transaction.entity");
const sms_recipient_entity_1 = require("./sms/sms-recipient.entity");
const sms_entity_1 = require("./sms/sms.entity");
const short_code_entity_1 = require("./short-code/short-code.entity");
const product_entity_1 = require("./product/product.entity");
const sms_view_entity_1 = require("./sms/sms.view.entity");
const sms_admin_search_cache_entity_1 = require("./sms/sms-admin-search-cache.entity");
const kyc_entity_1 = require("./kyc/kyc.entity");
const kyc_template_entity_1 = require("./kyc/kyc-template.entity");
const kyc_view_entity_1 = require("./kyc/kyc.view.entity");
const product_group_entity_1 = require("./product/product-group.entity");
const webhook_entity_1 = require("./webhook.entity");
const report_entity_1 = require("./report.entity");
const views = [sms_view_entity_1.SMSTransactionView, sms_view_entity_1.SMSTransactionAdminView, kyc_view_entity_1.KYCView, kyc_view_entity_1.KYCAnalysisView];
exports.entities = [
    la_nest_library_1.FileEntity,
    la_nest_library_1.LikesEntity,
    token_entity_1.TokenSessionEntity,
    partner_entity_1.PartnerEntity,
    sms_entity_1.SMSEntity,
    short_code_entity_1.ShortCodeEntity,
    sms_recipient_entity_1.SMSRecipientEntity,
    sms_transaction_entity_1.SMSTransactionEntity,
    sms_admin_search_cache_entity_1.SMSAdminSearchCacheEntity,
    webhook_entity_1.WebhookEntity,
    product_entity_1.ProductEntity,
    kyc_entity_1.KYCEntity,
    product_group_entity_1.ProductGroupEntity,
    kyc_template_entity_1.KYCTemplateEntity,
    report_entity_1.ReportEntity,
    ...views,
    ...authentication_module_1.AuthenticationModule.entities,
    ...la_nest_library_1.WordpressModule.entities,
    ...la_nest_library_1.SDKWalletModule.entities,
    ...la_nest_library_1.SDKFileModule.entities,
    ...la_nest_library_1.PricingModule.entities,
    ...la_nest_library_1.LoggerDBModule.entities,
];
//# sourceMappingURL=index.entities.js.map