"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchQueryDto = exports.BaseSMEntity = exports.BaseEntity = void 0;
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const class_validator_1 = require("class-validator");
const environment_service_1 = require("../services/environment.service");
const typeorm_1 = require("typeorm");
class BaseEntity extends la_nest_library_1.BaseEntity {
    constructor(obj) {
        super();
        if (obj)
            Object.assign(this, obj);
    }
}
exports.BaseEntity = BaseEntity;
__decorate([
    (0, typeorm_1.Column)({ nullable: true, select: false }),
    __metadata("design:type", String)
], BaseEntity.prototype, "lastUpdateID", void 0);
class BaseSMEntity extends BaseEntity {
}
exports.BaseSMEntity = BaseSMEntity;
__decorate([
    (0, typeorm_1.Column)({ unique: true, type: "double", nullable: true }),
    __metadata("design:type", Number)
], BaseSMEntity.prototype, "smID", void 0);
__decorate([
    (0, typeorm_1.Column)({ unique: true, type: "nvarchar", length: 250, nullable: true }),
    __metadata("design:type", String)
], BaseSMEntity.prototype, "asID", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], BaseSMEntity.prototype, "asAvatar", void 0);
__decorate([
    (0, typeorm_1.Column)({
        nullable: true,
        transformer: {
            from: (v) => (v ? `${environment_service_1.evt.isDev ? environment_service_1.evt.SERVER_URL : environment_service_1.evt.SERVER_HOST}/${v}` : v),
            to: (v) => v,
        },
    }),
    __metadata("design:type", String)
], BaseSMEntity.prototype, "avatar", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: "unset" }),
    __metadata("design:type", String)
], BaseSMEntity.prototype, "lastUpdateID", void 0);
class SearchQueryDto extends la_nest_library_1.SearchQueryDto {
}
exports.SearchQueryDto = SearchQueryDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", String)
], SearchQueryDto.prototype, "lastUpdateID", void 0);
//# sourceMappingURL=base.entity.js.map