import { BaseEntity as SDKBaseEntity, SearchQueryDto as SDKSearchQueryDto } from "@serene-dev/la-nest-library";
export declare abstract class BaseEntity<T = any> extends SDKBaseEntity {
    lastUpdateID?: string;
    constructor(obj?: T);
}
export declare abstract class BaseSMEntity<T = any> extends BaseEntity<T> {
    smID?: number;
    asID?: string;
    asAvatar?: string;
    avatar?: string;
    lastUpdateID: string;
}
export declare class SearchQueryDto<T = any> extends SDKSearchQueryDto<T> {
    lastUpdateID?: string;
}
export type EntityASAvatar<T extends BaseSMEntity> = Pick<T, "id" | "asAvatar">;
