"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResendWebhookResponseDto = exports.ResendWebhookDto = exports.SearchWebhookPublicDto = exports.SearchWebhookDto = exports.SearchWebhookResponse = exports.WebhookLogDto = exports.WebhookPayloadDto = exports.WebhookPayloadDataDto = exports.WebhookStatsDto = exports.UpdateWebhookUrlDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const webhook_enum_1 = require("../enums/webhook.enum");
const base_entity_1 = require("../entities/base.entity");
const search_dto_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/dtos/search.dto");
const sms_enum_1 = require("../enums/sms/sms.enum");
class UpdateWebhookUrlDto {
}
exports.UpdateWebhookUrlDto = UpdateWebhookUrlDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Webhook URL for receiving SMS status updates',
        example: 'https://api.example.com/webhooks/sms-status',
    }),
    (0, class_validator_1.IsUrl)({}, { message: 'webhookUrl must be a valid URL' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'webhookUrl is required' }),
    __metadata("design:type", String)
], UpdateWebhookUrlDto.prototype, "webhookUrl", void 0);
class WebhookStatsDto {
}
exports.WebhookStatsDto = WebhookStatsDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Total number of webhooks sent' }),
    (0, class_validator_1.IsNumber)({}, { message: 'total must be a number' }),
    (0, class_validator_1.IsInt)({ message: 'total must be an integer' }),
    (0, class_validator_1.Min)(0, { message: 'total must be non-negative' }),
    __metadata("design:type", Number)
], WebhookStatsDto.prototype, "total", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Number of successfully delivered webhooks' }),
    (0, class_validator_1.IsNumber)({}, { message: 'delivered must be a number' }),
    (0, class_validator_1.IsInt)({ message: 'delivered must be an integer' }),
    (0, class_validator_1.Min)(0, { message: 'delivered must be non-negative' }),
    __metadata("design:type", Number)
], WebhookStatsDto.prototype, "delivered", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Number of failed webhooks' }),
    (0, class_validator_1.IsNumber)({}, { message: 'failed must be a number' }),
    (0, class_validator_1.IsInt)({ message: 'failed must be an integer' }),
    (0, class_validator_1.Min)(0, { message: 'failed must be non-negative' }),
    __metadata("design:type", Number)
], WebhookStatsDto.prototype, "failed", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Number of pending webhooks' }),
    (0, class_validator_1.IsNumber)({}, { message: 'pending must be a number' }),
    (0, class_validator_1.IsInt)({ message: 'pending must be an integer' }),
    (0, class_validator_1.Min)(0, { message: 'pending must be non-negative' }),
    __metadata("design:type", Number)
], WebhookStatsDto.prototype, "pending", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Number of webhooks currently retrying' }),
    (0, class_validator_1.IsNumber)({}, { message: 'retrying must be a number' }),
    (0, class_validator_1.IsInt)({ message: 'retrying must be an integer' }),
    (0, class_validator_1.Min)(0, { message: 'retrying must be non-negative' }),
    __metadata("design:type", Number)
], WebhookStatsDto.prototype, "retrying", void 0);
class WebhookPayloadDataDto {
}
exports.WebhookPayloadDataDto = WebhookPayloadDataDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'SMS short code used for sending',
        example: '12345',
    }),
    (0, class_validator_1.IsString)({ message: 'shortCode must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'shortCode is required' }),
    __metadata("design:type", String)
], WebhookPayloadDataDto.prototype, "shortCode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Current SMS status',
        enum: sms_enum_1.ESMSStatus,
        example: sms_enum_1.ESMSStatus.delivered,
    }),
    (0, class_validator_1.IsEnum)(sms_enum_1.ESMSStatus, { message: 'status must be a valid SMS status' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'status is required' }),
    __metadata("design:type", String)
], WebhookPayloadDataDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Error code if SMS failed',
        enum: sms_enum_1.ESMSResponseCode,
        example: sms_enum_1.ESMSResponseCode.accountExpired,
    }),
    (0, class_validator_1.IsEnum)(sms_enum_1.ESMSResponseCode, {
        message: 'error must be a valid SMS response code',
    }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WebhookPayloadDataDto.prototype, "error", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Provider-specific error code',
        example: '000',
    }),
    (0, class_validator_1.IsString)({ message: 'errorCode must be a string' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WebhookPayloadDataDto.prototype, "errorCode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Human-readable error message',
        example: 'Message delivered successfully',
    }),
    (0, class_validator_1.IsString)({ message: 'errorMessage must be a string' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WebhookPayloadDataDto.prototype, "errorMessage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Cost of the SMS in the smallest currency unit',
        example: 50,
    }),
    (0, class_validator_1.IsNumber)({}, { message: 'amount must be a number' }),
    (0, class_validator_1.IsPositive)({ message: 'amount must be positive' }),
    __metadata("design:type", Number)
], WebhookPayloadDataDto.prototype, "amount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Unix timestamp when SMS was sent',
        example: 1705312200000,
    }),
    (0, class_validator_1.IsNumber)({}, { message: 'dateTimeSent must be a number' }),
    (0, class_validator_1.IsInt)({ message: 'dateTimeSent must be an integer' }),
    (0, class_validator_1.Min)(0, { message: 'dateTimeSent must be non-negative' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], WebhookPayloadDataDto.prototype, "dateTimeSent", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Unix timestamp when SMS was delivered',
        example: 1705312205000,
    }),
    (0, class_validator_1.IsNumber)({}, { message: 'dateTimeDelivered must be a number' }),
    (0, class_validator_1.IsInt)({ message: 'dateTimeDelivered must be an integer' }),
    (0, class_validator_1.Min)(0, { message: 'dateTimeDelivered must be non-negative' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], WebhookPayloadDataDto.prototype, "dateTimeDelivered", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Unix timestamp when SMS failed',
        example: null,
    }),
    (0, class_validator_1.IsNumber)({}, { message: 'dateTimeFailed must be a number' }),
    (0, class_validator_1.IsInt)({ message: 'dateTimeFailed must be an integer' }),
    (0, class_validator_1.Min)(0, { message: 'dateTimeFailed must be non-negative' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], WebhookPayloadDataDto.prototype, "dateTimeFailed", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Phone number of the recipient',
        example: '+2348012345678',
    }),
    (0, class_validator_1.IsString)({ message: 'recipient must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'recipient is required' }),
    __metadata("design:type", String)
], WebhookPayloadDataDto.prototype, "recipient", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'SMS message content',
        example: 'Your verification code is 123456',
    }),
    (0, class_validator_1.IsString)({ message: 'message must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'message is required' }),
    __metadata("design:type", String)
], WebhookPayloadDataDto.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Unique transaction identifier',
        example: 'txn_123456789',
    }),
    (0, class_validator_1.IsString)({ message: 'transactionId must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'transactionId is required' }),
    __metadata("design:type", String)
], WebhookPayloadDataDto.prototype, "transactionId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Unique transaction identifier',
        example: 'txn_123456789',
    }),
    (0, class_validator_1.IsString)({ message: 'reference must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'reference is required' }),
    __metadata("design:type", String)
], WebhookPayloadDataDto.prototype, "reference", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Provider-specific message ID',
        example: 'msg_987654321',
    }),
    (0, class_validator_1.IsString)({ message: 'messageId must be a string' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WebhookPayloadDataDto.prototype, "messageId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Client identifier who sent the SMS',
        example: 'client_123',
    }),
    (0, class_validator_1.IsString)({ message: 'clientId must be a string' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WebhookPayloadDataDto.prototype, "clientId", void 0);
class WebhookPayloadDto {
}
exports.WebhookPayloadDto = WebhookPayloadDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Webhook event type',
        enum: webhook_enum_1.EWebhookEventType,
        example: webhook_enum_1.EWebhookEventType.smsDelivered,
    }),
    (0, class_validator_1.IsEnum)(webhook_enum_1.EWebhookEventType, {
        message: 'event must be a valid webhook event type',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'event is required' }),
    __metadata("design:type", String)
], WebhookPayloadDto.prototype, "event", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Timestamp when the event occurred',
        example: '2024-01-15T10:30:00.000Z',
    }),
    (0, class_validator_1.IsString)({ message: 'timestamp must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'timestamp is required' }),
    __metadata("design:type", String)
], WebhookPayloadDto.prototype, "timestamp", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: WebhookPayloadDataDto }),
    (0, class_validator_1.IsNotEmpty)({ message: 'data is required' }),
    __metadata("design:type", WebhookPayloadDataDto)
], WebhookPayloadDto.prototype, "data", void 0);
class WebhookLogDto {
}
exports.WebhookLogDto = WebhookLogDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Webhook ID' }),
    (0, class_validator_1.IsString)({ message: 'id must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'id is required' }),
    __metadata("design:type", String)
], WebhookLogDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Partner ID' }),
    (0, class_validator_1.IsString)({ message: 'partnerId must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'partnerId is required' }),
    __metadata("design:type", String)
], WebhookLogDto.prototype, "partnerId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'SMS Transaction ID' }),
    (0, class_validator_1.IsString)({ message: 'smsTransactionId must be a string' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WebhookLogDto.prototype, "smsTransactionId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Webhook URL' }),
    (0, class_validator_1.IsUrl)({}, { message: 'url must be a valid URL' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'url is required' }),
    __metadata("design:type", String)
], WebhookLogDto.prototype, "url", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: WebhookPayloadDto, description: 'Webhook payload' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'payload is required' }),
    __metadata("design:type", WebhookPayloadDto)
], WebhookLogDto.prototype, "payload", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'HTTP response status code' }),
    (0, class_validator_1.IsNumber)({}, { message: 'responseStatus must be a number' }),
    (0, class_validator_1.IsInt)({ message: 'responseStatus must be an integer' }),
    (0, class_validator_1.Min)(100, { message: 'responseStatus must be a valid HTTP status code' }),
    (0, class_validator_1.Max)(599, { message: 'responseStatus must be a valid HTTP status code' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], WebhookLogDto.prototype, "responseStatus", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'HTTP response body' }),
    (0, class_validator_1.IsString)({ message: 'responseBody must be a string' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WebhookLogDto.prototype, "responseBody", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Webhook delivery status', enum: webhook_enum_1.EWebhookStatus }),
    (0, class_validator_1.IsEnum)(webhook_enum_1.EWebhookStatus, { message: 'status must be a valid webhook status' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'status is required' }),
    __metadata("design:type", String)
], WebhookLogDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Webhook event type', enum: webhook_enum_1.EWebhookEventType }),
    (0, class_validator_1.IsEnum)(webhook_enum_1.EWebhookEventType, {
        message: 'event must be a valid webhook event type',
    }),
    (0, class_validator_1.IsNotEmpty)({ message: 'event is required' }),
    __metadata("design:type", String)
], WebhookLogDto.prototype, "event", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Number of retry attempts' }),
    (0, class_validator_1.IsNumber)({}, { message: 'retryCount must be a number' }),
    (0, class_validator_1.IsInt)({ message: 'retryCount must be an integer' }),
    (0, class_validator_1.Min)(0, { message: 'retryCount must be non-negative' }),
    (0, class_validator_1.Max)(10, { message: 'retryCount cannot exceed 10' }),
    __metadata("design:type", Number)
], WebhookLogDto.prototype, "retryCount", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Error message if webhook failed' }),
    (0, class_validator_1.IsString)({ message: 'errorMessage must be a string' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], WebhookLogDto.prototype, "errorMessage", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Timestamp when webhook was delivered' }),
    (0, class_validator_1.IsNumber)({}, { message: 'deliveredAt must be a number' }),
    (0, class_validator_1.IsInt)({ message: 'deliveredAt must be an integer' }),
    (0, class_validator_1.Min)(0, { message: 'deliveredAt must be non-negative' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], WebhookLogDto.prototype, "deliveredAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Creation timestamp' }),
    (0, class_validator_1.IsString)({ message: 'createdAt must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'createdAt is required' }),
    __metadata("design:type", String)
], WebhookLogDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Last update timestamp' }),
    (0, class_validator_1.IsString)({ message: 'updatedAt must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'updatedAt is required' }),
    __metadata("design:type", String)
], WebhookLogDto.prototype, "updatedAt", void 0);
class SearchWebhookResponse extends search_dto_1.SearchResponseDto {
}
exports.SearchWebhookResponse = SearchWebhookResponse;
__decorate([
    (0, swagger_1.ApiProperty)({ type: [WebhookLogDto] }),
    __metadata("design:type", Array)
], SearchWebhookResponse.prototype, "data", void 0);
class SearchWebhookDto extends (0, swagger_1.IntersectionType)(base_entity_1.SearchQueryDto, (0, swagger_1.PartialType)(WebhookLogDto)) {
}
exports.SearchWebhookDto = SearchWebhookDto;
class SearchWebhookPublicDto extends (0, swagger_1.PickType)(SearchWebhookDto, [
    'status',
    'smsTransactionId',
    'createdFrom',
    'createdTo',
    'status',
    'errorMessage',
    'pageNumber',
    'pageSize',
    'responseStatus',
    'sortField',
    'sortDirection',
]) {
}
exports.SearchWebhookPublicDto = SearchWebhookPublicDto;
class ResendWebhookDto {
}
exports.ResendWebhookDto = ResendWebhookDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Webhook ID to resend',
        example: 'webhook_123456789',
    }),
    (0, class_validator_1.IsString)({ message: 'webhookId must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'webhookId is required' }),
    __metadata("design:type", String)
], ResendWebhookDto.prototype, "webhookId", void 0);
class ResendWebhookResponseDto {
}
exports.ResendWebhookResponseDto = ResendWebhookResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Webhook ID that was resent',
        example: 'webhook_123456789',
    }),
    (0, class_validator_1.IsString)({ message: 'webhookId must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'webhookId is required' }),
    __metadata("design:type", String)
], ResendWebhookResponseDto.prototype, "webhookId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Current webhook status after resend attempt',
        enum: webhook_enum_1.EWebhookStatus,
        example: webhook_enum_1.EWebhookStatus.retrying,
    }),
    (0, class_validator_1.IsEnum)(webhook_enum_1.EWebhookStatus, { message: 'status must be a valid webhook status' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'status is required' }),
    __metadata("design:type", String)
], ResendWebhookResponseDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Number of retry attempts',
        example: 1,
    }),
    (0, class_validator_1.IsNumber)({}, { message: 'retryCount must be a number' }),
    (0, class_validator_1.IsInt)({ message: 'retryCount must be an integer' }),
    (0, class_validator_1.Min)(0, { message: 'retryCount must be non-negative' }),
    (0, class_validator_1.Max)(10, { message: 'retryCount cannot exceed 10' }),
    __metadata("design:type", Number)
], ResendWebhookResponseDto.prototype, "retryCount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Success message',
        example: 'Webhook resend triggered successfully',
    }),
    (0, class_validator_1.IsString)({ message: 'message must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'message is required' }),
    __metadata("design:type", String)
], ResendWebhookResponseDto.prototype, "message", void 0);
//# sourceMappingURL=webhook.dto.js.map