import { EWebhookStatus, EWebhookEventType } from '../enums/webhook.enum';
import { SearchQueryDto } from '../entities/base.entity';
import { SearchResponseDto } from '@serene-dev/la-nest-library/dist/libs/la-library/src/dtos/search.dto';
import { WebhookEntity } from '../entities/webhook.entity';
import { ESMSStatus, ESMSResponseCode } from '../enums/sms/sms.enum';
export declare class UpdateWebhookUrlDto {
    webhookUrl: string;
}
export declare class WebhookStatsDto {
    total: number;
    delivered: number;
    failed: number;
    pending: number;
    retrying: number;
}
export declare class WebhookPayloadDataDto {
    shortCode: string;
    status: ESMSStatus;
    error?: ESMSResponseCode;
    errorCode?: string;
    errorMessage?: string;
    amount: number;
    dateTimeSent?: number;
    dateTimeDelivered?: number;
    dateTimeFailed?: number;
    recipient: string;
    message: string;
    transactionId: string;
    reference: string;
    messageId?: string;
    clientId?: string;
}
export declare class WebhookPayloadDto {
    event: EWebhookEventType;
    timestamp: string;
    data: WebhookPayloadDataDto;
}
export declare class WebhookLogDto implements WebhookEntity {
    id: string;
    partnerId: string;
    smsTransactionId?: string;
    url: string;
    payload: WebhookPayloadDto;
    responseStatus?: number;
    responseBody?: string;
    status: EWebhookStatus;
    event: EWebhookEventType;
    retryCount: number;
    errorMessage?: string;
    deliveredAt?: number;
    createdAt: string;
    updatedAt: string;
}
export declare class SearchWebhookResponse extends SearchResponseDto {
    data: WebhookLogDto[];
}
declare const SearchWebhookDto_base: import("@nestjs/common").Type<Partial<WebhookLogDto> & SearchQueryDto<unknown>>;
export declare class SearchWebhookDto extends SearchWebhookDto_base {
}
declare const SearchWebhookPublicDto_base: import("@nestjs/common").Type<Pick<SearchWebhookDto, "status" | "errorMessage" | "smsTransactionId" | "responseStatus" | "createdFrom" | "createdTo" | "pageNumber" | "pageSize" | "sortField" | "sortDirection">>;
export declare class SearchWebhookPublicDto extends SearchWebhookPublicDto_base {
}
export declare class ResendWebhookDto {
    webhookId: string;
}
export declare class ResendWebhookResponseDto {
    webhookId: string;
    status: EWebhookStatus;
    retryCount: number;
    message: string;
}
export {};
