"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SendSMSConfig = exports.ReconcileSMSDTO = exports.SearchSMSClientDTO = exports.SearchSMSAdminDTO = exports.SearchSMSDTO = exports.SendSMSResponseDto = exports.SendBulkSMSDto = exports.SendSMSDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const sms_enum_1 = require("../enums/sms/sms.enum");
const class_validator_1 = require("class-validator");
const class_transformer_1 = require("class-transformer");
const base_entity_1 = require("../entities/base.entity");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
class SendSMSDto {
}
exports.SendSMSDto = SendSMSDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SendSMSDto.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SendSMSDto.prototype, "shortCode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: sms_enum_1.ESMSType }),
    (0, class_validator_1.IsEnum)(sms_enum_1.ESMSType),
    __metadata("design:type", String)
], SendSMSDto.prototype, "type", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [String] }),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsPhoneNumber)('NG', { each: true }),
    __metadata("design:type", Array)
], SendSMSDto.prototype, "recipients", void 0);
class SendBulkSMSDto {
}
exports.SendBulkSMSDto = SendBulkSMSDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: [SendSMSDto] }),
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_transformer_1.Type)(() => SendSMSDto),
    __metadata("design:type", Array)
], SendBulkSMSDto.prototype, "data", void 0);
class SendSMSResponseDto {
}
exports.SendSMSResponseDto = SendSMSResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ enum: sms_enum_1.ESMSStatus }),
    __metadata("design:type", String)
], SendSMSResponseDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: sms_enum_1.ESMSResponseCode, required: false }),
    __metadata("design:type", String)
], SendSMSResponseDto.prototype, "error", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], SendSMSResponseDto.prototype, "reference", void 0);
class SearchSMSDTO extends base_entity_1.SearchQueryDto {
}
exports.SearchSMSDTO = SearchSMSDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SearchSMSDTO.prototype, "message", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], SearchSMSDTO.prototype, "receipient", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], SearchSMSDTO.prototype, "clientId", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ enum: sms_enum_1.ESMSType }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(sms_enum_1.ESMSType),
    __metadata("design:type", String)
], SearchSMSDTO.prototype, "type", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], SearchSMSDTO.prototype, "amount", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ enum: sms_enum_1.ESMSStatus }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(sms_enum_1.ESMSStatus),
    __metadata("design:type", String)
], SearchSMSDTO.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], SearchSMSDTO.prototype, "dateTimeDelivered", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], SearchSMSDTO.prototype, "dateTimeFailed", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Number)
], SearchSMSDTO.prototype, "dateTimeSent", void 0);
class SearchSMSAdminDTO extends SearchSMSDTO {
}
exports.SearchSMSAdminDTO = SearchSMSAdminDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], SearchSMSAdminDTO.prototype, "providerId", void 0);
class SearchSMSClientDTO extends SearchSMSDTO {
}
exports.SearchSMSClientDTO = SearchSMSClientDTO;
class ReconcileSMSDTO {
}
exports.ReconcileSMSDTO = ReconcileSMSDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ type: [la_nest_library_1.IDDto] }),
    (0, class_validator_1.ValidateNested)({ each: true }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", Array)
], ReconcileSMSDTO.prototype, "ids", void 0);
class SendSMSConfig {
}
exports.SendSMSConfig = SendSMSConfig;
//# sourceMappingURL=sms.dto.js.map