import { ESMSResponseCode, ESMSStatus, ESMSType } from '../enums/sms/sms.enum';
import { SearchQueryDto } from '../entities/base.entity';
import { SMSTransactionView } from '../entities/sms/sms.view.entity';
import { IDDto } from '@serene-dev/la-nest-library';
import { EProvider } from '../enums/provider.enum';
export declare class SendSMSDto {
    message: string;
    shortCode: string;
    type: ESMSType;
    recipients: string[];
}
export declare class SendBulkSMSDto {
    data: SendSMSDto[];
}
export declare class SendSMSResponseDto {
    status: ESMSStatus;
    error?: ESMSResponseCode;
    reference: string;
}
export declare class SearchSMSDTO extends SearchQueryDto<SMSTransactionView> {
    message?: string;
    receipient?: string;
    clientId?: string;
    type?: ESMSType;
    amount?: number;
    status?: ESMSStatus;
    dateTimeDelivered?: number;
    dateTimeFailed?: number;
    dateTimeSent?: number;
}
export declare class SearchSMSAdminDTO extends SearchSMSDTO {
    providerId?: string;
}
export declare class SearchSMSClientDTO extends SearchSMSDTO {
}
export declare class ReconcileSMSDTO {
    ids?: IDDto[];
}
export declare class SendSMSConfig {
    provider?: EProvider;
}
