"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShortCodeAnalysisDto = exports.ShortCodeAnalysisReqDto = exports.SearchShortCodeClientDTO = exports.SearchShortCodeDTO = exports.RequestShortCodesDTO = exports.RequestShortCodesClientDTO = exports.SetShortCodesStatus = exports.CreateShortCodeDTO = void 0;
const class_validator_1 = require("class-validator");
const swagger_1 = require("@nestjs/swagger");
const base_entity_1 = require("../entities/base.entity");
const short_code_enum_1 = require("../enums/short-code.enum");
class CreateShortCodeDTO {
}
exports.CreateShortCodeDTO = CreateShortCodeDTO;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], CreateShortCodeDTO.prototype, "code", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], CreateShortCodeDTO.prototype, "orgID", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: short_code_enum_1.EShortCodeStatus }),
    (0, class_validator_1.IsEnum)(short_code_enum_1.EShortCodeStatus),
    __metadata("design:type", String)
], CreateShortCodeDTO.prototype, "status", void 0);
class SetShortCodesStatus {
}
exports.SetShortCodesStatus = SetShortCodesStatus;
__decorate([
    (0, class_validator_1.IsString)({ each: true }),
    (0, swagger_1.ApiProperty)({ type: [String] }),
    (0, class_validator_1.IsArray)(),
    __metadata("design:type", Array)
], SetShortCodesStatus.prototype, "ids", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: short_code_enum_1.EShortCodeStatus }),
    (0, class_validator_1.IsEnum)(short_code_enum_1.EShortCodeStatus),
    __metadata("design:type", String)
], SetShortCodesStatus.prototype, "status", void 0);
class RequestShortCodesClientDTO {
}
exports.RequestShortCodesClientDTO = RequestShortCodesClientDTO;
__decorate([
    (0, class_validator_1.IsString)({ each: true }),
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsArray)(),
    __metadata("design:type", Array)
], RequestShortCodesClientDTO.prototype, "codes", void 0);
class RequestShortCodesDTO extends RequestShortCodesClientDTO {
}
exports.RequestShortCodesDTO = RequestShortCodesDTO;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsUUID)(),
    (0, swagger_1.ApiPropertyOptional)(),
    __metadata("design:type", String)
], RequestShortCodesDTO.prototype, "orgID", void 0);
class SearchShortCodeDTO extends (0, swagger_1.IntersectionType)(base_entity_1.SearchQueryDto, (0, swagger_1.PartialType)(CreateShortCodeDTO)) {
}
exports.SearchShortCodeDTO = SearchShortCodeDTO;
class SearchShortCodeClientDTO extends (0, swagger_1.OmitType)(SearchShortCodeDTO, ['orgID']) {
}
exports.SearchShortCodeClientDTO = SearchShortCodeClientDTO;
class ShortCodeAnalysisReqDto {
}
exports.ShortCodeAnalysisReqDto = ShortCodeAnalysisReqDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], ShortCodeAnalysisReqDto.prototype, "clientID", void 0);
class ShortCodeAnalysisDto {
}
exports.ShortCodeAnalysisDto = ShortCodeAnalysisDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], ShortCodeAnalysisDto.prototype, "whitelisted", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], ShortCodeAnalysisDto.prototype, "toBeWhitelisted", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Number)
], ShortCodeAnalysisDto.prototype, "toBeDropped", void 0);
//# sourceMappingURL=short-code.dto.js.map