"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchReportDto = exports.ReportResponseDto = exports.CreateReportDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const base_entity_1 = require("../entities/base.entity");
const report_entity_1 = require("../entities/report.entity");
const swagger_2 = require("@nestjs/swagger");
class CreateReportDto {
}
exports.CreateReportDto = CreateReportDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Report type/identifier',
        example: 'sms_transactions',
    }),
    (0, class_validator_1.IsString)({ message: 'reportType must be a string' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreateReportDto.prototype, "reportType", void 0);
class ReportResponseDto {
}
exports.ReportResponseDto = ReportResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Report ID' }),
    __metadata("design:type", String)
], ReportResponseDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Auto-generated report number',
        example: 'RPT-SMS-1',
    }),
    __metadata("design:type", String)
], ReportResponseDto.prototype, "reportNumber", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Report status',
        enum: report_entity_1.EReportStatus,
    }),
    __metadata("design:type", String)
], ReportResponseDto.prototype, "status", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'File path where report is stored' }),
    __metadata("design:type", String)
], ReportResponseDto.prototype, "filePath", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Total number of records' }),
    __metadata("design:type", Number)
], ReportResponseDto.prototype, "totalRecords", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Number of records processed' }),
    __metadata("design:type", Number)
], ReportResponseDto.prototype, "processedRecords", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Number of chunks processed' }),
    __metadata("design:type", Number)
], ReportResponseDto.prototype, "processedChunks", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Error message if failed' }),
    __metadata("design:type", String)
], ReportResponseDto.prototype, "errorMessage", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'User who requested the report' }),
    __metadata("design:type", String)
], ReportResponseDto.prototype, "requestedBy", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Report type' }),
    __metadata("design:type", String)
], ReportResponseDto.prototype, "reportType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Creation timestamp' }),
    __metadata("design:type", String)
], ReportResponseDto.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Last update timestamp' }),
    __metadata("design:type", String)
], ReportResponseDto.prototype, "updatedAt", void 0);
class SearchReportDto extends (0, swagger_2.IntersectionType)(base_entity_1.SearchQueryDto, (0, swagger_2.PartialType)(ReportResponseDto)) {
}
exports.SearchReportDto = SearchReportDto;
//# sourceMappingURL=report.dto.js.map