"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssignProductDto = exports.GetClientWalletDto = exports.SearchProviderDTO = exports.SearchPartnerDTO = exports.UpdatePartnerDTO = exports.CreateClientDTO = exports.CreatePartnerDTO = void 0;
const class_validator_1 = require("class-validator");
const swagger_1 = require("@nestjs/swagger");
const base_entity_1 = require("../entities/base.entity");
const provider_enum_1 = require("../enums/provider.enum");
const class_transformer_1 = require("class-transformer");
const sms_enum_1 = require("../enums/sms/sms.enum");
const wallet_dto_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.dto");
const authentication_dto_1 = require("../modules/authentication/dtos/authentication.dto");
class CreatePartnerDTO {
}
exports.CreatePartnerDTO = CreatePartnerDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsPhoneNumber)(),
    __metadata("design:type", String)
], CreatePartnerDTO.prototype, "phoneNumber", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEmail)(),
    __metadata("design:type", String)
], CreatePartnerDTO.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreatePartnerDTO.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], CreatePartnerDTO.prototype, "webhookUrl", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)(),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], CreatePartnerDTO.prototype, "priority", void 0);
class CreateClientDTO {
}
exports.CreateClientDTO = CreateClientDTO;
__decorate([
    (0, swagger_1.ApiProperty)({ type: CreatePartnerDTO }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => CreatePartnerDTO),
    __metadata("design:type", CreatePartnerDTO)
], CreateClientDTO.prototype, "client", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: authentication_dto_1.RegisterUserDTO }),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => authentication_dto_1.RegisterUserDTO),
    __metadata("design:type", authentication_dto_1.RegisterUserDTO)
], CreateClientDTO.prototype, "user", void 0);
class UpdatePartnerDTO extends (0, swagger_1.PartialType)(CreatePartnerDTO) {
}
exports.UpdatePartnerDTO = UpdatePartnerDTO;
class SearchPartnerDTO extends (0, swagger_1.IntersectionType)(base_entity_1.SearchQueryDto, UpdatePartnerDTO) {
}
exports.SearchPartnerDTO = SearchPartnerDTO;
class SearchProviderDTO extends (0, swagger_1.IntersectionType)(SearchPartnerDTO) {
}
exports.SearchProviderDTO = SearchProviderDTO;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ enum: provider_enum_1.EProvider }),
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEnum)(provider_enum_1.EProvider),
    __metadata("design:type", String)
], SearchProviderDTO.prototype, "providerCode", void 0);
class GetClientWalletDto {
}
exports.GetClientWalletDto = GetClientWalletDto;
__decorate([
    (0, swagger_1.ApiProperty)({ enum: sms_enum_1.ESMSType }),
    (0, class_validator_1.IsEnum)(sms_enum_1.ESMSType),
    __metadata("design:type", String)
], GetClientWalletDto.prototype, "walletType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], GetClientWalletDto.prototype, "netBalance", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], GetClientWalletDto.prototype, "grossTotalCredit", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], GetClientWalletDto.prototype, "grossTotalDebit", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], GetClientWalletDto.prototype, "netTotalCredit", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    __metadata("design:type", Number)
], GetClientWalletDto.prototype, "netTotalDebit", void 0);
class AssignProductDto extends (0, swagger_1.OmitType)(wallet_dto_1.CreateWalletTransactionDTO, [
    'currency',
    'isFailed',
    'isVerified',
    'refCat',
    'reason',
    'surcharge',
    'type',
]) {
}
exports.AssignProductDto = AssignProductDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.Min)(0),
    (0, class_transformer_1.Type)(() => Number),
    __metadata("design:type", Number)
], AssignProductDto.prototype, "amount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], AssignProductDto.prototype, "clientID", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.IsUUID)(),
    __metadata("design:type", String)
], AssignProductDto.prototype, "productID", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: sms_enum_1.ESMSType }),
    (0, class_validator_1.IsEnum)(sms_enum_1.ESMSType),
    __metadata("design:type", String)
], AssignProductDto.prototype, "smsType", void 0);
//# sourceMappingURL=partner.dto.js.map