import { SearchQueryDto } from '../entities/base.entity';
import { PartnerEntity } from '../entities/partner.entity';
import { EProvider } from '../enums/provider.enum';
import { EPartnerType } from '../enums/partner.enum';
import { ESMSType } from '../enums/sms/sms.enum';
import { CreateWalletTransactionDTO } from '@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.dto';
import { RegisterUserDTO } from '../modules/authentication/dtos/authentication.dto';
export declare class CreatePartnerDTO implements Partial<PartnerEntity> {
    phoneNumber?: string;
    email?: string;
    name: string;
    webhookUrl?: string;
    priority?: number;
    providerCode?: EProvider;
}
export declare class CreateClientDTO {
    client: CreatePartnerDTO;
    user: RegisterUserDTO;
}
declare const UpdatePartnerDTO_base: import("@nestjs/common").Type<Partial<CreatePartnerDTO>>;
export declare class UpdatePartnerDTO extends UpdatePartnerDTO_base {
}
declare const SearchPartnerDTO_base: import("@nestjs/common").Type<SearchQueryDto<unknown> & UpdatePartnerDTO>;
export declare class SearchPartnerDTO extends SearchPartnerDTO_base implements Partial<PartnerEntity> {
    type: EPartnerType;
}
declare const SearchProviderDTO_base: import("@nestjs/common").Type<SearchPartnerDTO>;
export declare class SearchProviderDTO extends SearchProviderDTO_base implements Partial<PartnerEntity> {
    providerCode?: EProvider;
}
export declare class GetClientWalletDto {
    walletType: ESMSType;
    netBalance: number;
    grossTotalCredit: number;
    grossTotalDebit: number;
    netTotalCredit: number;
    netTotalDebit: number;
}
declare const AssignProductDto_base: import("@nestjs/common").Type<Omit<CreateWalletTransactionDTO, "type" | "currency" | "isFailed" | "isVerified" | "refCat" | "reason" | "surcharge">>;
export declare class AssignProductDto extends AssignProductDto_base {
    amount: number;
    clientID: string;
    productID: string;
    smsType: ESMSType;
}
export {};
