"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MontyCallbackDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const sms_monty_enum_1 = require("../enums/sms/sms.monty.enum");
const class_transformer_1 = require("class-transformer");
class _MontyCallbackDto {
}
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Date and time when the message was received/processed',
        example: '04:01 PM 24/11/2025',
    }),
    (0, class_validator_1.IsString)({ message: 'ReceiveDate must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'ReceiveDate is required' }),
    __metadata("design:type", String)
], _MontyCallbackDto.prototype, "ReceiveDate", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Mobile number of the recipient',
        example: '2348012345678',
    }),
    (0, class_validator_1.IsString)({ message: 'MobileNo must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'MobileNo is required' }),
    __metadata("design:type", String)
], _MontyCallbackDto.prototype, "MobileNo", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Unique message ID from Monty provider',
        example: 'msg_123456789',
    }),
    (0, class_validator_1.IsString)({ message: 'MessageId must be a string' }),
    (0, class_validator_1.IsNotEmpty)({ message: 'MessageId is required' }),
    __metadata("design:type", String)
], _MontyCallbackDto.prototype, "MessageId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Status ID of the message (2=Delivered, 3=Expired, 4=Deleted, 5=Undelivered, 6=Accepted, 7=Invalid, 8=Rejected)',
        enum: sms_monty_enum_1.ESMSMontyStatusId,
        example: sms_monty_enum_1.ESMSMontyStatusId.delivered,
    }),
    (0, class_validator_1.IsEnum)(sms_monty_enum_1.ESMSMontyStatusId),
    (0, class_validator_1.IsNotEmpty)({ message: 'StatusId is required' }),
    __metadata("design:type", String)
], _MontyCallbackDto.prototype, "StatusId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Error message if any error occurred',
        example: '000',
        required: false,
    }),
    (0, class_validator_1.IsString)({ message: 'err must be a string' }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], _MontyCallbackDto.prototype, "err", void 0);
class MontyCallbackDto {
}
exports.MontyCallbackDto = MontyCallbackDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, class_validator_1.ValidateNested)(),
    (0, class_transformer_1.Type)(() => _MontyCallbackDto),
    __metadata("design:type", _MontyCallbackDto)
], MontyCallbackDto.prototype, "CallBackResponse", void 0);
//# sourceMappingURL=monty.dto.js.map