import { SearchQueryDto } from '@serene-dev/la-nest-library';
import { KYCEntity } from '../../entities/kyc/kyc.entity';
import { BaseDto } from '../base.dto';
import { EKYCStatus } from '../../enums/kyc.enum';
import { KYCAnalysisView, KYCView } from '../../entities/kyc/kyc.view.entity';
export declare class CreateKYCDTO extends BaseDto implements Omit<Partial<KYCEntity>, 'file'> {
    userComment?: string;
    templateId: string;
    clientId?: string;
    dataURI: string;
    fileExtension: string;
}
declare const UpdateKYCDTO_base: import("@nestjs/common").Type<Partial<CreateKYCDTO>>;
export declare class UpdateKYCDTO extends UpdateKYCDTO_base {
}
declare const SearchKYCDTO_base: import("@nestjs/common").Type<SearchQueryDto<unknown>>;
export declare class SearchKYCDTO extends SearchKYCDTO_base implements Partial<KYCView> {
    status?: EKYCStatus;
    required?: boolean;
    templateActive?: boolean;
    userComment?: string;
    review?: string;
    fileId?: string;
    reviewerId?: string;
    templateId?: string;
    clientId?: string;
    code: string;
    title: string;
    description: string;
    clientName: string;
    reviewer: string;
    creator: any | string;
    updater: any | string;
}
declare const SearchKYCAnalysisDTO_base: import("@nestjs/common").Type<SearchQueryDto<unknown>>;
export declare class SearchKYCAnalysisDTO extends SearchKYCAnalysisDTO_base implements Partial<KYCAnalysisView> {
    status?: EKYCStatus;
    required?: boolean;
    templateActive?: boolean;
    approved?: boolean;
    templatesCount?: number;
    clientId?: string;
    clientName?: string;
    approvedCount?: number;
    pendingCount?: number;
    rejectedCount?: number;
}
export declare class SetKYCStatusDTO {
    status: EKYCStatus;
    id: string;
    review?: string;
}
export {};
