"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebhookController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("../services/utility.service");
const webhook_service_1 = require("../services/webhook/webhook.service");
const jwt_auth_guard_1 = require("../modules/authentication/guards/jwt-auth.guard");
const authentication_enum_1 = require("../modules/authentication/enums/authentication.enum");
const webhook_dto_1 = require("../dtos/webhook.dto");
let WebhookController = class WebhookController {
    constructor(webhookService) {
        this.webhookService = webhookService;
    }
    async getStats(auth) {
        try {
            const stats = await this.webhookService.getWebhookStats(auth.id);
            return utility_service_1.UtilityClass.handleSuccess({
                data: stats,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getLogs(query, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.webhookService.search(query, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async testWebhook(body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: { ...body, _received: true },
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async resendWebhook(param, auth) {
        try {
            const result = await this.webhookService.resendWebhook(param.id, auth);
            return utility_service_1.UtilityClass.handleSuccess({
                data: result,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async sendBySMSTransId(param, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.webhookService.sendWebhookBySMSTransactionId(param.id, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.WebhookController = WebhookController;
__decorate([
    (0, common_1.Get)('stats'),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], WebhookController.prototype, "getStats", null);
__decorate([
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiResponse)({ type: webhook_dto_1.SearchWebhookResponse }),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [webhook_dto_1.SearchWebhookDto, Object]),
    __metadata("design:returntype", Promise)
], WebhookController.prototype, "getLogs", null);
__decorate([
    (0, common_1.Post)('test'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [webhook_dto_1.WebhookPayloadDto]),
    __metadata("design:returntype", Promise)
], WebhookController.prototype, "testWebhook", null);
__decorate([
    (0, common_1.Post)('resend/:id'),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto, Object]),
    __metadata("design:returntype", Promise)
], WebhookController.prototype, "resendWebhook", null);
__decorate([
    (0, common_1.Post)('sendBySMSTransactionId/:id'),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto, Object]),
    __metadata("design:returntype", Promise)
], WebhookController.prototype, "sendBySMSTransId", null);
exports.WebhookController = WebhookController = __decorate([
    (0, swagger_1.ApiTags)('Webhook'),
    (0, common_1.Controller)('webhook'),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [webhook_service_1.WebhookService])
], WebhookController);
//# sourceMappingURL=webhook.controller.js.map