import { IDDto } from '@serene-dev/la-nest-library';
import { IAuthParam } from 'src/modules/authentication/interfaces/authentication.interface';
import { WebhookService } from '../services/webhook/webhook.service';
import { SearchWebhookDto, WebhookPayloadDto } from '../dtos/webhook.dto';
export declare class WebhookController {
    private readonly webhookService;
    constructor(webhookService: WebhookService);
    getStats(auth: IAuthParam): Promise<string | {
        total: number;
        delivered: number;
        failed: number;
        pending: number;
        retrying: number;
    }>;
    getLogs(query: SearchWebhookDto, auth: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<import("../entities/webhook.entity").WebhookEntity>>;
    testWebhook(body: WebhookPayloadDto): Promise<string | {
        _received: boolean;
        event: import("../enums/webhook.enum").EWebhookEventType;
        timestamp: string;
        data: import("../dtos/webhook.dto").WebhookPayloadDataDto;
    }>;
    resendWebhook(param: IDDto, auth: IAuthParam): Promise<string | {
        webhookId: string;
        status: import("../enums/webhook.enum").EWebhookStatus;
        retryCount: number;
        message: string;
    }>;
    sendBySMSTransId(param: IDDto, auth: IAuthParam): Promise<string | void>;
}
