"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SMSController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("../../services/utility.service");
const sms_service_1 = require("../../services/sms/sms.service");
const sms_dto_1 = require("../../dtos/sms.dto");
const sms_view_service_1 = require("../../services/sms/sms.view.service");
const jwt_auth_guard_1 = require("../../modules/authentication/guards/jwt-auth.guard");
const authentication_enum_1 = require("../../modules/authentication/enums/authentication.enum");
const report_service_1 = require("../../services/report.service");
const report_entity_1 = require("../../entities/report.entity");
let SMSController = class SMSController {
    constructor(reportService, service, smsViewsService) {
        this.reportService = reportService;
        this.service = service;
        this.smsViewsService = smsViewsService;
    }
    async search(query, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.smsViewsService.searchTransactions(query, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async reconcileMessageStatuses(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.reconcileMessageStatuses(body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async searchAdmin(query, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.reportService.handleSearchWithExport(query, this.service.searchTransactions, report_entity_1.EReportType.smsLogsForAdmin, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.SMSController = SMSController;
__decorate([
    (0, common_1.Get)(`search/public`),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sms_dto_1.SearchSMSDTO, Object]),
    __metadata("design:returntype", Promise)
], SMSController.prototype, "search", null);
__decorate([
    (0, common_1.Patch)('reconcileMessageStatuses'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sms_dto_1.ReconcileSMSDTO, Object]),
    __metadata("design:returntype", Promise)
], SMSController.prototype, "reconcileMessageStatuses", null);
__decorate([
    (0, common_1.Get)(`search/admin`),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sms_dto_1.SearchSMSAdminDTO, Object]),
    __metadata("design:returntype", Promise)
], SMSController.prototype, "searchAdmin", null);
exports.SMSController = SMSController = __decorate([
    (0, swagger_1.ApiTags)(sms_service_1.SMSService.path.tag),
    (0, common_1.Controller)(sms_service_1.SMSService.path.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [report_service_1.ReportService,
        sms_service_1.SMSService,
        sms_view_service_1.SMSViewsService])
], SMSController);
//# sourceMappingURL=sms.controller.js.map