"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShortCodeController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const base_controller_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller");
const utility_service_1 = require("../services/utility.service");
const short_code_service_1 = require("../services/short-code/short-code.service");
const short_code_dto_1 = require("../dtos/short-code.dto");
const client_service_1 = require("../services/partner/client.service");
const jwt_auth_guard_1 = require("../modules/authentication/guards/jwt-auth.guard");
const authentication_enum_1 = require("../modules/authentication/enums/authentication.enum");
let ShortCodeController = class ShortCodeController extends base_controller_1.BaseCRUDController {
    constructor(service, clientService) {
        super(service);
        this.service = service;
        this.clientService = clientService;
    }
    async search(query, auth) {
        if (!auth?.isAdmin)
            query.orgID = await this.clientService.authIDToClientID(auth.id);
        return super.search(query, auth);
    }
    create(body, auth) {
        return super.create(body, auth);
    }
    async shortCodeAnalysis(query, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.shortCodeAnalysis(auth, query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async requestShortcode(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.requestShortcodeWhitelist(body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async requestShortcodeDrop(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.requestShortcodeDrop(body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async setShortCodesStatus(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.setShortCodesStatus(body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.ShortCodeController = ShortCodeController;
__decorate([
    (0, common_1.Get)('search'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [short_code_dto_1.SearchShortCodeDTO, Object]),
    __metadata("design:returntype", Promise)
], ShortCodeController.prototype, "search", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [short_code_dto_1.CreateShortCodeDTO, Object]),
    __metadata("design:returntype", void 0)
], ShortCodeController.prototype, "create", null);
__decorate([
    (0, common_1.Get)('analysis'),
    (0, swagger_1.ApiResponse)({ type: short_code_dto_1.ShortCodeAnalysisDto }),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [short_code_dto_1.ShortCodeAnalysisReqDto, Object]),
    __metadata("design:returntype", Promise)
], ShortCodeController.prototype, "shortCodeAnalysis", null);
__decorate([
    (0, common_1.Post)(`request`),
    (0, swagger_1.ApiResponse)({ type: short_code_dto_1.ShortCodeAnalysisDto }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [short_code_dto_1.RequestShortCodesDTO, Object]),
    __metadata("design:returntype", Promise)
], ShortCodeController.prototype, "requestShortcode", null);
__decorate([
    (0, common_1.Post)(`drop`),
    (0, swagger_1.ApiResponse)({ type: short_code_dto_1.ShortCodeAnalysisDto }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [short_code_dto_1.RequestShortCodesDTO, Object]),
    __metadata("design:returntype", Promise)
], ShortCodeController.prototype, "requestShortcodeDrop", null);
__decorate([
    (0, common_1.Post)(`setStatus`),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [short_code_dto_1.SetShortCodesStatus, Object]),
    __metadata("design:returntype", Promise)
], ShortCodeController.prototype, "setShortCodesStatus", null);
exports.ShortCodeController = ShortCodeController = __decorate([
    (0, swagger_1.ApiTags)(short_code_service_1.ShortCodeService.tag),
    (0, common_1.Controller)(short_code_service_1.ShortCodeService.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [short_code_service_1.ShortCodeService,
        client_service_1.ClientService])
], ShortCodeController);
//# sourceMappingURL=short-code.controller.js.map