import { IAuthParam } from 'src/modules/authentication/interfaces/authentication.interface';
import { BaseCRUDController } from '@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller';
import { ShortCodeEntity } from '../entities/short-code/short-code.entity';
import { ShortCodeService } from '../services/short-code/short-code.service';
import { CreateShortCodeDTO, RequestShortCodesDTO, SearchShortCodeDTO, SetShortCodesStatus, ShortCodeAnalysisDto, ShortCodeAnalysisReqDto } from '../dtos/short-code.dto';
import { ClientService } from '../services/partner/client.service';
export declare class ShortCodeController extends BaseCRUDController<ShortCodeEntity, SearchShortCodeDTO> {
    protected service: ShortCodeService;
    clientService: ClientService;
    constructor(service: ShortCodeService, clientService: ClientService);
    search(query: SearchShortCodeDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<ShortCodeEntity>>;
    create(body: CreateShortCodeDTO, auth: IAuthParam): string | Promise<ShortCodeEntity>;
    shortCodeAnalysis(query: ShortCodeAnalysisReqDto, auth: IAuthParam): Promise<string | ShortCodeAnalysisDto>;
    requestShortcode(body: RequestShortCodesDTO, auth: IAuthParam): Promise<string | ShortCodeAnalysisDto>;
    requestShortcodeDrop(body: RequestShortCodesDTO, auth: IAuthParam): Promise<string | ShortCodeAnalysisDto>;
    setShortCodesStatus(body: SetShortCodesStatus, auth: IAuthParam): Promise<string | {
        message: string;
    }>;
}
