"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReportController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("../services/utility.service");
const report_service_1 = require("../services/report.service");
const report_dto_1 = require("../dtos/report.dto");
const fs_1 = require("fs");
const report_entity_1 = require("../entities/report.entity");
let ReportController = class ReportController {
    constructor(reportService) {
        this.reportService = reportService;
    }
    async getReport(param, auth) {
        try {
            const report = await this.reportService.getReport(param.id);
            if (!auth.isAdmin && report.requestedBy !== auth.id) {
                return utility_service_1.UtilityClass.handleError({
                    message: 'Unauthorized to view this report',
                });
            }
            return utility_service_1.UtilityClass.handleSuccess({
                data: report,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async downloadReport(param, res, auth) {
        try {
            const report = await this.reportService.getReport(param.id);
            if (!auth.isAdmin && report.requestedBy !== auth.id) {
                return utility_service_1.UtilityClass.handleError({
                    message: 'Unauthorized to download this report',
                });
            }
            if (report.status !== report_entity_1.EReportStatus.completed) {
                return utility_service_1.UtilityClass.handleError({
                    message: `Report is not ready. Current status: ${report.status}`,
                });
            }
            const filePath = this.reportService.getReportFilePath(report);
            if (!filePath || !(0, fs_1.existsSync)(filePath)) {
                return utility_service_1.UtilityClass.handleError({
                    message: 'Report file not found',
                });
            }
            res.download(filePath, `report_${report.reportType}.csv`, (err) => {
                if (err) {
                    return utility_service_1.UtilityClass.handleError(err);
                }
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async searchReports(query, auth) {
        try {
            const result = await this.reportService.search(query, auth);
            return utility_service_1.UtilityClass.handleSuccess({
                data: result,
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.ReportController = ReportController;
__decorate([
    (0, common_1.Get)(':id'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    (0, swagger_1.ApiResponse)({ type: report_dto_1.ReportResponseDto }),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto, Object]),
    __metadata("design:returntype", Promise)
], ReportController.prototype, "getReport", null);
__decorate([
    (0, common_1.Get)(':id/download'),
    (0, la_nest_library_1.QueryParamAuth)(),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Res)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto, Object, Object]),
    __metadata("design:returntype", Promise)
], ReportController.prototype, "downloadReport", null);
__decorate([
    (0, common_1.Get)(),
    (0, la_nest_library_1.SDKPublicAuth)(),
    (0, swagger_1.ApiResponse)({ description: 'Paginated reports' }),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [report_dto_1.SearchReportDto, Object]),
    __metadata("design:returntype", Promise)
], ReportController.prototype, "searchReports", null);
exports.ReportController = ReportController = __decorate([
    (0, swagger_1.ApiTags)('REPORT'),
    (0, common_1.Controller)('report'),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [report_service_1.ReportService])
], ReportController);
//# sourceMappingURL=report.controller.js.map