"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const utility_service_1 = require("../services/utility.service");
const product_service_1 = require("../services/product.service");
const product_dto_1 = require("../dtos/product.dto");
const analytics_dto_1 = require("../dtos/analytics.dto");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
let ProductController = class ProductController {
    constructor(service) {
        this.service = service;
    }
    async getPricing() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.pricingList(),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getAnalytics() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getAnalytics(),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.ProductController = ProductController;
__decorate([
    (0, common_1.Get)(``),
    (0, la_nest_library_1.SDKPublicAuth)(),
    (0, swagger_1.ApiResponse)({ type: [product_dto_1.ProductItemDto] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getPricing", null);
__decorate([
    (0, common_1.Get)(`analytics`),
    (0, swagger_1.ApiResponse)({ type: [analytics_dto_1.Chart] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "getAnalytics", null);
exports.ProductController = ProductController = __decorate([
    (0, swagger_1.ApiTags)(product_service_1.ProductService.path.tag),
    (0, common_1.Controller)(product_service_1.ProductService.path.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [product_service_1.ProductService])
], ProductController);
//# sourceMappingURL=products.controller.js.map