"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MontyController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const utility_service_1 = require("../../services/utility.service");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const monty_provider_service_1 = require("../../services/sms/sms-providers/monty-provider.service");
const monty_dto_1 = require("../../dtos/monty.dto");
let MontyController = class MontyController {
    constructor(service) {
        this.service = service;
    }
    async handleCallback(body) {
        try {
            await this.service.callback(body);
            return utility_service_1.UtilityClass.handleSuccess({
                data: { message: 'Thank you 😘' },
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.MontyController = MontyController;
__decorate([
    (0, common_1.Post)('callback'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [monty_dto_1.MontyCallbackDto]),
    __metadata("design:returntype", Promise)
], MontyController.prototype, "handleCallback", null);
exports.MontyController = MontyController = __decorate([
    (0, swagger_1.ApiTags)('MONTY'),
    (0, common_1.Controller)('monty'),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [monty_provider_service_1.MontyProviderService])
], MontyController);
//# sourceMappingURL=monty.controller.js.map