"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const partner_controller_1 = require("./partner.controller");
const client_service_1 = require("../../services/partner/client.service");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const utility_service_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/services/utility.service");
const base_dto_1 = require("../../dtos/base.dto");
const wallet_dto_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.dto");
const partner_dto_1 = require("../../dtos/partner.dto");
const webhook_dto_1 = require("../../dtos/webhook.dto");
let ClientController = class ClientController extends partner_controller_1.PartnerController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    async regenerateAPIKey(params, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.generateKeyExt(auth, params.id),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async createPublic(body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.createPublic(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async shortCodeAnalysis(auth, id) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.generateKeyExt(auth, id.id),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async assignPlan(auth, body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.assignClientToProduct(body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getWallet(auth, query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await (auth?.isAdmin
                    ? this.service.getOrCreateWallet(query.id)
                    : this.service.getOrCreateWalletByAuth(auth)),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getWalletByID(auth, param) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getWalletByID(param.id, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async searchWalletTransactions(auth, query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.searchWalletTransactions(query, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async updateWebhookUrl(auth, body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.updateWebhookUrl(auth, body.webhookUrl),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getWebhookUrl(auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getWebhookUrl(auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.ClientController = ClientController;
__decorate([
    (0, common_1.Put)('key/regenerate/:id'),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto, Object]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "regenerateAPIKey", null);
__decorate([
    (0, common_1.Post)('register'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [partner_dto_1.CreateClientDTO]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "createPublic", null);
__decorate([
    (0, common_1.Post)(':id/apiKey'),
    (0, swagger_1.ApiResponse)({ type: base_dto_1.GenericResponseDto }),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, la_nest_library_1.IDDto]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "shortCodeAnalysis", null);
__decorate([
    (0, common_1.Post)('plan/assign'),
    (0, swagger_1.ApiResponse)({ type: base_dto_1.GenericResponseDto }),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, partner_dto_1.AssignProductDto]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "assignPlan", null);
__decorate([
    (0, common_1.Get)('wallet'),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, base_dto_1.IDQueryDto]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "getWallet", null);
__decorate([
    (0, common_1.Get)('wallet/:id'),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, la_nest_library_1.IDDto]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "getWalletByID", null);
__decorate([
    (0, common_1.Get)('wallet/transactions/search'),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __param(1, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, wallet_dto_1.WalletTransactionSearchDTO]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "searchWalletTransactions", null);
__decorate([
    (0, common_1.Put)('webhook/url'),
    (0, swagger_1.ApiResponse)({ type: base_dto_1.GenericResponseDto }),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, webhook_dto_1.UpdateWebhookUrlDto]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "updateWebhookUrl", null);
__decorate([
    (0, common_1.Get)('webhook/url'),
    (0, swagger_1.ApiResponse)({ type: base_dto_1.GenericResponseDto }),
    __param(0, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ClientController.prototype, "getWebhookUrl", null);
exports.ClientController = ClientController = __decorate([
    (0, swagger_1.ApiTags)(client_service_1.ClientService.tag),
    (0, common_1.Controller)(client_service_1.ClientService.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [client_service_1.ClientService])
], ClientController);
//# sourceMappingURL=client.controller.js.map