import { PartnerController } from './partner.controller';
import { ClientService } from '../../services/partner/client.service';
import { IDDto } from '@serene-dev/la-nest-library';
import { GenericResponseDto, IDQueryDto } from '../../dtos/base.dto';
import { IAuthParam } from '../../modules/authentication/interfaces/authentication.interface';
import { WalletTransactionSearchDTO } from '@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.dto';
import { AssignProductDto, CreateClientDTO } from '../../dtos/partner.dto';
import { UpdateWebhookUrlDto } from '../../dtos/webhook.dto';
export declare class ClientController extends PartnerController {
    protected service: ClientService;
    constructor(service: ClientService);
    regenerateAPIKey(params: IDDto, auth: IAuthParam): Promise<string | void>;
    createPublic(body: CreateClientDTO): Promise<any>;
    shortCodeAnalysis(auth: IAuthParam, id: IDDto): Promise<string | void>;
    assignPlan(auth: IAuthParam, body: AssignProductDto): Promise<string | {
        message: string;
    }>;
    getWallet(auth: IAuthParam, query: IDQueryDto): Promise<string | {
        wallet: import("@serene-dev/la-nest-library").SDKWalletGrossBalanceView;
        type: import("../../enums/sms/sms.enum").ESMSType;
    }[]>;
    getWalletByID(auth: IAuthParam, param: IDDto): Promise<string | import("@serene-dev/la-nest-library").SDKWalletGrossBalanceView | {
        wallet: import("@serene-dev/la-nest-library").SDKWalletGrossBalanceView;
        type: import("../../enums/sms/sms.enum").ESMSType;
    }[]>;
    searchWalletTransactions(auth: IAuthParam, query: WalletTransactionSearchDTO): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<import("@serene-dev/la-nest-library").SDKWalletTransaction>>;
    updateWebhookUrl(auth: IAuthParam, body: UpdateWebhookUrlDto): Promise<string | GenericResponseDto>;
    getWebhookUrl(auth: IAuthParam): Promise<string | {
        webhookUrl?: string;
    }>;
}
