"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BriccsController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const briccs_provider_service_1 = require("../../services/sms/sms-providers/briccs-provider.service");
const utility_service_1 = require("../../services/utility.service");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const sms_dto_1 = require("../../dtos/sms.dto");
const sms_service_1 = require("../../services/sms/sms.service");
const authentication_enum_1 = require("../../modules/authentication/enums/authentication.enum");
const jwt_auth_guard_1 = require("../../modules/authentication/guards/jwt-auth.guard");
let BriccsController = class BriccsController {
    constructor(service, smsService) {
        this.service = service;
        this.smsService = smsService;
    }
    async reconcileMessageStatuses(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.reconcileMessageStatuses(),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async send(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.sender(this.smsService.dtoToEntity(body)),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.BriccsController = BriccsController;
__decorate([
    (0, common_1.Patch)('reconcileMessageStatuses'),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sms_dto_1.ReconcileSMSDTO, Object]),
    __metadata("design:returntype", Promise)
], BriccsController.prototype, "reconcileMessageStatuses", null);
__decorate([
    (0, common_1.Post)('send'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [sms_dto_1.SendSMSDto, Object]),
    __metadata("design:returntype", Promise)
], BriccsController.prototype, "send", null);
exports.BriccsController = BriccsController = __decorate([
    (0, swagger_1.ApiTags)('BRICCS'),
    (0, common_1.Controller)('briccs'),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [briccs_provider_service_1.BriccsProviderService,
        sms_service_1.SMSService])
], BriccsController);
//# sourceMappingURL=briccs.controller.js.map