"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.KYCController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const base_controller_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller");
const kyc_service_1 = require("../../services/kyc/kyc.service");
const kyc_dto_1 = require("../../dtos/kyc/kyc.dto");
const kyc_view_service_1 = require("../../services/kyc/kyc.view.service");
const utility_service_1 = require("../../services/utility.service");
const kyc_enum_1 = require("../../enums/kyc.enum");
const jwt_auth_guard_1 = require("../../modules/authentication/guards/jwt-auth.guard");
const authentication_enum_1 = require("../../modules/authentication/enums/authentication.enum");
let KYCController = class KYCController extends base_controller_1.BaseCRUDController {
    constructor(service, viewService) {
        super(service);
        this.service = service;
        this.viewService = viewService;
    }
    async search(query, auth) {
        return super.search(query, auth, (query, auth) => this.viewService.search(query, auth));
    }
    async searchAnalysis(query, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.viewService.searchAnalysis(query, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getStatuses() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: utility_service_1.UtilityClass.returnEnum(kyc_enum_1.EKYCStatus),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async setStatus(body, auth) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.setStatus(body, auth),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    create(body, auth) {
        return super.create(body, auth);
    }
    updateByID(param, body, auth) {
        return super.updateByID(param, body, auth);
    }
};
exports.KYCController = KYCController;
__decorate([
    (0, common_1.Get)('search'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [kyc_dto_1.SearchKYCDTO, Object]),
    __metadata("design:returntype", Promise)
], KYCController.prototype, "search", null);
__decorate([
    (0, common_1.Get)('search/analysis'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [kyc_dto_1.SearchKYCAnalysisDTO, Object]),
    __metadata("design:returntype", Promise)
], KYCController.prototype, "searchAnalysis", null);
__decorate([
    (0, common_1.Get)('statuses'),
    (0, la_nest_library_1.SDKPublicAuth)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], KYCController.prototype, "getStatuses", null);
__decorate([
    (0, common_1.Patch)('status'),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [kyc_dto_1.SetKYCStatusDTO, Object]),
    __metadata("design:returntype", Promise)
], KYCController.prototype, "setStatus", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [kyc_dto_1.CreateKYCDTO, Object]),
    __metadata("design:returntype", void 0)
], KYCController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(':id'),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto,
        kyc_dto_1.UpdateKYCDTO, Object]),
    __metadata("design:returntype", void 0)
], KYCController.prototype, "updateByID", null);
exports.KYCController = KYCController = __decorate([
    (0, swagger_1.ApiTags)(kyc_service_1.KYCService.tag),
    (0, common_1.Controller)(kyc_service_1.KYCService.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [kyc_service_1.KYCService,
        kyc_view_service_1.KYCViewService])
], KYCController);
//# sourceMappingURL=kyc.controller.js.map