import { IDDto } from '@serene-dev/la-nest-library';
import { IAuthParam } from 'src/modules/authentication/interfaces/authentication.interface';
import { BaseCRUDController } from '@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller';
import { KYCService } from '../../services/kyc/kyc.service';
import { KYCEntity } from '../../entities/kyc/kyc.entity';
import { CreateKYCDTO, SearchKYCAnalysisDTO, SearchKYCDTO, SetKYCStatusDTO, UpdateKYCDTO } from '../../dtos/kyc/kyc.dto';
import { KYCViewService } from '../../services/kyc/kyc.view.service';
export declare class KYCController extends BaseCRUDController<KYCEntity, SearchKYCDTO> {
    protected service: KYCService;
    protected viewService: KYCViewService;
    constructor(service: KYCService, viewService: KYCViewService);
    search(query: SearchKYCDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<KYCEntity>>;
    searchAnalysis(query: SearchKYCAnalysisDTO, auth?: IAuthParam): Promise<string | import("@serene-dev/la-nest-library").ISearchResponse<import("../../entities/kyc/kyc.view.entity").KYCAnalysisView>>;
    getStatuses(): Promise<string | import("@serene-dev/la-nest-library").ValueLabelDto<any>[]>;
    setStatus(body: SetKYCStatusDTO, auth: IAuthParam): Promise<string | KYCEntity>;
    create(body: CreateKYCDTO, auth: IAuthParam): string | Promise<KYCEntity>;
    updateByID(param: IDDto, body: UpdateKYCDTO, auth: IAuthParam): string | Promise<KYCEntity>;
}
