"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.KYCTemplateController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const base_controller_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/controllers/base.controller");
const utility_service_1 = require("../../services/utility.service");
const kyc_template_service_1 = require("../../services/kyc/kyc-template.service");
const kyc_template_dto_1 = require("../../dtos/kyc/kyc-template.dto");
const jwt_auth_guard_1 = require("../../modules/authentication/guards/jwt-auth.guard");
const authentication_enum_1 = require("../../modules/authentication/enums/authentication.enum");
let KYCTemplateController = class KYCTemplateController extends base_controller_1.BaseCRUDController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    async search(query, auth) {
        return super.search(query, auth);
    }
    async getAll() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getAll(),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    create(body, auth) {
        return super.create(body, auth);
    }
    updateByID(param, body, auth) {
        return super.updateByID(param, body, auth);
    }
};
exports.KYCTemplateController = KYCTemplateController;
__decorate([
    __param(0, (0, common_1.Query)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], KYCTemplateController.prototype, "search", null);
__decorate([
    (0, common_1.Get)(''),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], KYCTemplateController.prototype, "getAll", null);
__decorate([
    (0, common_1.Post)(),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [kyc_template_dto_1.CreateKYCTemplateDTO, Object]),
    __metadata("design:returntype", void 0)
], KYCTemplateController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(':id'),
    __param(0, (0, common_1.Param)()),
    __param(1, (0, common_1.Body)()),
    __param(2, (0, la_nest_library_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [la_nest_library_1.IDDto,
        kyc_template_dto_1.UpdateKYCTemplateDTO, Object]),
    __metadata("design:returntype", void 0)
], KYCTemplateController.prototype, "updateByID", null);
exports.KYCTemplateController = KYCTemplateController = __decorate([
    (0, swagger_1.ApiTags)(kyc_template_service_1.KYCTemplateService.tag),
    (0, common_1.Controller)(kyc_template_service_1.KYCTemplateService.path),
    (0, jwt_auth_guard_1.Role)(authentication_enum_1.EAuthType.admin),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [kyc_template_service_1.KYCTemplateService])
], KYCTemplateController);
//# sourceMappingURL=kyc-template.controller.js.map