"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const analytics_dto_1 = require("../dtos/analytics.dto");
const utility_service_1 = require("../services/utility.service");
class BaseController extends la_nest_library_1.SDKBaseController {
    constructor(service) {
        super(service);
        this.service = service;
        this.subject = `Item`;
        this.idParam = `id`;
    }
    async analytics(params) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getAnalytics(params),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
}
exports.BaseController = BaseController;
BaseController.toggleBulkPath = `toggle/bulk`;
__decorate([
    (0, common_1.Get)('analytics'),
    (0, swagger_1.ApiResponse)({ type: [analytics_dto_1.Chart] }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [analytics_dto_1.ChartQueryDto]),
    __metadata("design:returntype", Promise)
], BaseController.prototype, "analytics", null);
//# sourceMappingURL=base.controller.js.map