import { SDKBaseController } from '@serene-dev/la-nest-library';
import { Chart, ChartQueryDto } from 'src/dtos/analytics.dto';
import { BaseEntity, SearchQueryDto } from 'src/entities/base.entity';
import { BaseService } from 'src/services/base.service';
export declare class BaseController<TEntity extends BaseEntity, TSearchDto extends SearchQueryDto = SearchQueryDto> extends SDKBaseController<TEntity, TSearchDto> {
    protected readonly service: BaseService<TEntity, TSearchDto>;
    subject: string;
    idParam: string;
    static toggleBulkPath: string;
    constructor(service: BaseService<TEntity, TSearchDto>);
    analytics(params: ChartQueryDto): Promise<string | Chart[]>;
}
