"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.connectionSource = void 0;
const config_1 = require("@nestjs/config");
const dotenv_1 = require("dotenv");
const typeorm_1 = require("typeorm");
const path = require("path");
console.log('pathh', path.join(__dirname, '../.env'));
let parsedEnv = (0, dotenv_1.config)();
if (parsedEnv.error)
    parsedEnv = (0, dotenv_1.config)({ path: path.join(__dirname, '../.env') });
const config = {
    type: 'mysql',
    host: process.env.DATABASE_HOST,
    port: +process.env.DATABASE_PORT,
    username: process.env.DATABASE_USERNAME,
    password: process.env.DATABASE_PASSWORD,
    database: process.env.DATABASE_NAME,
    synchronize: false,
    entities: ['dist/entities/index.entities.js'],
    migrations: ['dist/migrations/**/*{.js,.ts}'],
    migrationsTableName: 'migrations',
    autoLoadEntities: true,
    connectTimeout: 20000,
    retryAttempts: process.env.ENVIRONMENT == 'dev' ? 1 : 10,
    timezone: '+01:00',
    driver: require('mysql2'),
    extra: {},
};
exports.default = (0, config_1.registerAs)('typeorm', () => config);
exports.connectionSource = new typeorm_1.DataSource(config);
//# sourceMappingURL=typeorm.config.js.map