"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mailTemplates = void 0;
const theme_enum_1 = require("../enums/theme.enum");
const environment_service_1 = require("../services/environment.service");
const transLogo = {
    [theme_enum_1.ETheme.mesaj]: `<img src="data:image/png;base64,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" alt="" />`,
};
const bgColour = {
    [theme_enum_1.ETheme.mesaj]: `#fff`,
};
exports.mailTemplates = {
    general: (config) => `
  <!doctype html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
  </head>
  <body>
    
    <div class="case" style="font-family: system-ui;padding: 30px;width: 500px;margin: auto;">
      <div style="border: 1px solid #dfdfdf;padding: 10px;">
        <div class="card" style="background-color: #ffffff;">
          <div class="card-header" style="padding: 15px;background-color: ${bgColour[environment_service_1.evt.THEME]};color: #ffffff;text-shadow: 0 0 10px #0000001e;font-size: 20px;font-weight: 600;text-align: center;border-color: ${bgColour[environment_service_1.evt.THEME]} !important;">
          ${transLogo[environment_service_1.evt.THEME]}
            <div> ${config.header}</div>
          </div>
          <div class="card-body" style="padding: 15px;padding-top: 20px;min-height: 450px;border-bottom: 5px solid ${bgColour[environment_service_1.evt.THEME]} !important;">${config.body}</div>
          <div class="card-footer" style="text-align: center;padding: 20px;color: #ffffff;font-size: 15px;background-color: ${bgColour[environment_service_1.evt.THEME]}a8;">${config.footer || `© ${environment_service_1.evt.APP_NAME} ${new Date().getFullYear()}`}</div>
        </div>
      </div>
    </div>
  </body>
</html>
  `,
};
//# sourceMappingURL=mail-template.config.js.map