"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppService = void 0;
const common_1 = require("@nestjs/common");
const provider_service_1 = require("./services/partner/provider.service");
const client_service_1 = require("./services/partner/client.service");
const short_code_service_1 = require("./services/short-code/short-code.service");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const paystack_1 = require("@serene-dev/paystack");
const wallet_enum_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.enum");
const environment_service_1 = require("./services/environment.service");
const wallet_service_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet.service");
const wallet_transaction_service_1 = require("@serene-dev/la-nest-library/dist/libs/la-library/src/modules/wallet/wallet-transaction.service");
const product_service_1 = require("./services/product.service");
let AppService = class AppService {
    constructor(providerService, clientService, shortCodeService, pricingService, productService, walletService, walletTransactionService, endpointLoggerService) {
        this.providerService = providerService;
        this.clientService = clientService;
        this.shortCodeService = shortCodeService;
        this.pricingService = pricingService;
        this.productService = productService;
        this.walletService = walletService;
        this.walletTransactionService = walletTransactionService;
        this.endpointLoggerService = endpointLoggerService;
        this.pricingService.updateControllerBlock({
            create: true,
            update: true,
            delete: true,
            toggle: true,
        });
        this.walletService.updateControllerBlock({
            create: true,
            update: true,
            delete: true,
            toggle: true,
        });
        this.providerService.setupPartners().then(() => {
            this.clientService.setupTestClient().then((client) => {
                this.shortCodeService.setupTestShortCodes(client);
            });
            this.productService.loadPricingToDBFromConfig();
        });
        this.walletTransactionService.blacklistTransMethod([
            wallet_enum_1.ETransMethod.manual,
            wallet_enum_1.ETransMethod.fincra,
        ]);
        this.endpointLoggerService.skipCondition = async (auth) => auth?.isClient;
        setTimeout(() => {
            paystack_1.PaystackService.setConfig({
                currency: wallet_enum_1.ECurrency.naira,
                secretKey: environment_service_1.evt.PS_SECRET_KEY,
            });
        }, 1000);
    }
    getHello() {
        return 'Hello World!';
    }
};
exports.AppService = AppService;
exports.AppService = AppService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [provider_service_1.ProviderService,
        client_service_1.ClientService,
        short_code_service_1.ShortCodeService,
        la_nest_library_1.PricingService,
        product_service_1.ProductService,
        wallet_service_1.WalletService,
        wallet_transaction_service_1.WalletTransactionService,
        la_nest_library_1.EndpointLoggerService])
], AppService);
//# sourceMappingURL=app.service.js.map