"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const app_controller_1 = require("./app.controller");
const app_service_1 = require("./app.service");
const axios_1 = require("@nestjs/axios");
const config_1 = require("@nestjs/config");
const jwt_1 = require("@nestjs/jwt");
const platform_express_1 = require("@nestjs/platform-express");
const typeorm_1 = require("@nestjs/typeorm");
const la_nest_library_1 = require("@serene-dev/la-nest-library");
const index_entities_1 = require("./entities/index.entities");
const environment_service_1 = require("./services/environment.service");
const index_controllers_1 = require("./controllers/index.controllers");
const index_service_1 = require("./services/index.service");
const jwt_auth_guard_1 = require("./modules/authentication/guards/jwt-auth.guard");
const authentication_module_1 = require("./modules/authentication/authentication.module");
const client_module_1 = require("./modules/client/client.module");
const index_repository_1 = require("./repositories/index.repository");
const public_users_service_1 = require("./modules/authentication/services/public-users.service");
const monty_provider_service_1 = require("./services/sms/sms-providers/monty-provider.service");
const api_service_1 = require("./services/api.service");
const provider_service_1 = require("./services/partner/provider.service");
const sms_repository_1 = require("./repositories/sms/sms.repository");
const sms_transaction_repository_1 = require("./repositories/sms/sms-transaction.repository");
const sms_recipient_repository_1 = require("./repositories/sms/sms-recipient.repository");
const sms_admin_search_cache_repository_1 = require("./repositories/sms/sms-admin-search-cache.repository");
const partner_repository_1 = require("./repositories/partner.repository");
const sms_transaction_service_1 = require("./services/sms/sms-transaction.service");
const sms_service_1 = require("./services/sms/sms.service");
const sms_view_service_1 = require("./services/sms/sms.view.service");
const sms_admin_search_cache_service_1 = require("./services/sms/sms-admin-search-cache.service");
const product_service_1 = require("./services/product.service");
const client_service_1 = require("./services/partner/client.service");
const kyc_service_1 = require("./services/kyc/kyc.service");
const kyc_view_service_1 = require("./services/kyc/kyc.view.service");
const kyc_template_service_1 = require("./services/kyc/kyc-template.service");
const sms_provider_service_1 = require("./services/sms/sms-providers/sms-provider.service");
const short_code_provider_service_1 = require("./services/short-code/short-code-provider.service");
const short_code_service_1 = require("./services/short-code/short-code.service");
const briccs_provider_service_1 = require("./services/sms/sms-providers/briccs-provider.service");
const hollatags_provider_service_1 = require("./services/sms/sms-providers/hollatags-provider.service");
const webhook_service_1 = require("./services/webhook/webhook.service");
const report_service_1 = require("./services/report.service");
const typeorm_config_1 = require("./configs/typeorm.config");
const path = require("path");
const token_service_1 = require("./services/token.service");
const schedule_1 = require("@nestjs/schedule");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            la_nest_library_1.LaLibraryModule,
            authentication_module_1.AuthenticationModule,
            la_nest_library_1.SDKNotificationModule,
            la_nest_library_1.PricingModule,
            la_nest_library_1.SDKFileModule,
            monty_provider_service_1.MontyProviderModule,
            api_service_1.APIModule,
            provider_service_1.ProviderServiceModule,
            sms_repository_1.SMSRepositoryModule,
            sms_transaction_repository_1.SMSTransactionRepositoryModule,
            sms_recipient_repository_1.SMSRecipientRepositoryModule,
            sms_admin_search_cache_repository_1.SMSAdminSearchCacheRepositoryModule,
            partner_repository_1.PartnerRepositoryModule,
            sms_transaction_service_1.SMSTransactionServiceModule,
            sms_service_1.SMSServiceModule,
            sms_view_service_1.SMSViewsServiceModule,
            sms_admin_search_cache_service_1.SMSAdminSearchCacheServiceModule,
            product_service_1.ProductServiceModule,
            client_service_1.ClientServiceModule,
            kyc_service_1.KYCServiceModule,
            kyc_view_service_1.KYCViewServiceModule,
            kyc_template_service_1.KYCTemplateServiceModule,
            sms_provider_service_1.SMSProviderServiceModule,
            short_code_provider_service_1.ShortCodeProviderServiceModule,
            short_code_service_1.ShortCodeServiceModule,
            briccs_provider_service_1.BriccsProviderServiceModule,
            hollatags_provider_service_1.HollaTagsProviderServiceModule,
            webhook_service_1.WebhookServiceModule,
            report_service_1.ReportServiceModule,
            token_service_1.TokenModule,
            schedule_1.ScheduleModule.forRoot({
                cronJobs: process.env.NO_DB_STUFF != 'true',
            }),
            config_1.ConfigModule.forRoot({
                isGlobal: true,
                load: [typeorm_config_1.default],
                envFilePath: path.join(__dirname, './.env'),
            }),
            typeorm_1.TypeOrmModule.forRootAsync({
                inject: [config_1.ConfigService],
                useFactory: async (configService) => configService.get('typeorm'),
            }),
            typeorm_1.TypeOrmModule.forFeature(index_entities_1.entities),
            jwt_1.JwtModule.registerAsync({
                global: true,
                useClass: environment_service_1.EnvironmentService,
            }),
            platform_express_1.MulterModule.registerAsync({
                useClass: environment_service_1.EnvironmentService,
            }),
            axios_1.HttpModule,
            la_nest_library_1.SDKLogsModule,
            la_nest_library_1.WordpressModule,
            la_nest_library_1.SDKWalletModule,
            la_nest_library_1.LoggerDBModule,
            client_module_1.ClientModule,
        ],
        controllers: [app_controller_1.AppController, ...index_controllers_1.Controllers],
        providers: [
            app_service_1.AppService,
            environment_service_1.EnvironmentService,
            ...index_service_1.Services,
            ...index_repository_1.Repositories,
            public_users_service_1.PublicUsersService,
            jwt_auth_guard_1.JwtAuthGuard.provideGuard(),
            la_nest_library_1.LoggerDBModule.provideEndpointLoggerInterceptor(),
        ],
        exports: [...index_service_1.Services],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map